<?php
/**
 *
 * @package  RealEstateManager
 * @copyright 2012 Andrey Kvasnevskiy-OrdaSoft (akbet@mail.ru); Rob de Cleen (rob@decleen.com);
 * Homepage: http://www.ordasoft.com
 *
 */

if (!defined('_VALID_MOS') && !defined('_JEXEC')) die('Direct Access to ' . basename(__FILE__) . ' is not allowed.');

class com_RealEstateManagerInstallerScript {

    /**
     * method to run before an install/update/uninstall method
     *
     * @return void
     */
    function preflight($type, $parent) {
        // $parent is the class calling this method
        // $type is the type of change (install, update or discover_install)

        // Save admin settings before updete
        if ( $type == 'update' ) {
            // $realestatemanager_configuration:
            if(is_file(JPATH_ROOT . '/administrator/components/com_realestatemanager/realestatemanager.class.conf.php') ) {
                require(JPATH_ROOT . '/administrator/components/com_realestatemanager/realestatemanager.class.conf.php');
                if(isset($realestatemanager_configuration) )
                    $GLOBALS['realestatemanager_configuration_old'] = $realestatemanager_configuration;
            }
        }

        $db = JFactory::getDBO();
        $db->setQuery("DELETE FROM #__update_sites WHERE name = 'Realestatemanager`s Update'");
        $db->execute();

    }

    /**
     * method to install the component
     *
     * @return void
     */
    function install($parent) {
        
        // $parent is the class calling this method
    }

    /**
     * method to update the component
     *
     * @return void
     */
    function update($parent) {
        
        // $parent is the class calling this method

    }

    /**
     * method to uninstall the component
     *
     * @return void
     */
    function uninstall($parent) {
        
        // $parent is the class calling this method
        require_once(JPATH_SITE . "/administrator/components/com_realestatemanager/uninstall.realestatemanager.php");
    }

    /**
     * method to run after an install/update/uninstall method
     *
     * @return void
     */
    function postflight($type, $parent) {
        // $parent is the class calling this method
        // $type is the type of change (install, update or discover_install)

        // Marge old admin settings and new configuration after update
        global $realestatemanager_configuration_old;

        if ( $type == 'update' ) {
            // $realestatemanager_configuration new from update files
            if(is_file(JPATH_ROOT . '/administrator/components/com_realestatemanager/realestatemanager.class.conf_new.php') ) {
                require(JPATH_ROOT . '/administrator/components/com_realestatemanager/realestatemanager.class.conf_new.php');
                if(isset($realestatemanager_configuration) && isset($realestatemanager_configuration_old)  )
                    $realestatemanager_configuration = array_replace_recursive($realestatemanager_configuration, $realestatemanager_configuration_old);
            }
        }
        // In J4 method postflight calling on uninstall too.
        // https://docs.joomla.org/Potential_backward_compatibility_issues_in_Joomla_4
        if ( $type == 'install' || $type == 'update' ) {
            require_once(JPATH_SITE . "/administrator/components/com_realestatemanager/install.realestatemanager.php");
            com_install2();
        }
    }

}
