(function ($) {
    var plgSysTopOfThePage = function (options) {
        var root = this;
        var vars = {
            busy:false
        };

        this.construct = function (options) {
            $.extend(vars, options);
            createLink();
        };
        
        var createLink = function() {
            var location = vars.linklocation.split('_');
            var link = $('<span id="plg_system_topofthepage" aria-label="'+Joomla.JText._('PLG_SYS_TOPOFTHEPAGE_ARIA_LABEL')+'"></span>').appendTo(document.body);
            
            if(!parseInt(vars.omittext)) {
                $('<span class="buttontext">'+Joomla.JText._('PLG_SYS_TOPOFTHEPAGE_GOTOTOP')+'</span>').appendTo(link);
            }
            var styles = {
                position:'fixed',
                opacity:0,
                filter:'alpha(opacity=0)'
            };
            switch(location[0]) {
                case 'top':
                    styles.top = '0px';
                    break;
                default: // bottom
                    styles.bottom = '0px';
                    break;
            }
            switch(location[1]) {
                case 'left':
                    styles.left = '0px';
                    break;
                case 'center':
                    styles.left = (($(window).width()/2)-($(link).width()/2))+'px';
                    break;
                default: // right
                    styles.right = '0px';
                    break;
            }
            
            if(parseInt(vars.zIndex)) {
                styles['z-index'] = highZ(document.body) + 1;
            }
            
            $(link).css(styles);
            
            var actions = prepLink(link);
            prepWindow(link,actions);
            prepClick(link);
            if(parseInt(vars.topalways)) {
                $('body,html').scrollTop(0);
            }
        };
        
        var prepLink = function (link) {
            var opacity = (vars.pro?parseInt(vars.visibleopacity):100)/100;
            opacity = (opacity > 1 || opacity < 0)?1:opacity;
            var show = {opacity:opacity};
            var hide = {opacity:0,display:'block'};
            
            $(link).css(hide);
            return {show:show,hide:hide};
        };
        
        var prepWindow = function(link,actions) {
            $(window).scroll(function () {
                var options = {queue:false,duration:parseInt(vars.displaydur),easing:'linear'};
                if(!vars.busy) {
                    if ($(this).scrollTop() >= parseInt(vars.spyposition)) {
                        if(parseInt($(link).css('opacity')) === 0) {
                            vars.busy = true;
                            $(link).animate(actions.show,options);
                            vars.busy = false;
                        }
                    } else {
                        if($(link).css('opacity') !== 0) {
                            vars.busy = true;
                            $(link).animate(actions.hide,options);
                            vars.busy = false;
                        }
                    }
                }
            });
            $(window).scroll();
        };
        
        var prepClick = function(link) {
            // scroll body to 0px on click
            $(link).click(function (e) {
                var duration = parseInt(vars.smoothscrollduration);
                var transition = vars.smoothscrolltransition;
                                
                if(duration !== 0) {
                    $('body,html').animate({scrollTop:0},duration,transition);
                } else {
                    $('body,html').scrollTop(0);
                }
                return false;
            });    
        };
        
        var highZ = function(parent, limit){
            limit = limit || Infinity;
            parent = parent || document.body;
            var who, temp, max = 1, A = [], i = 0;
            var children = parent.childNodes, length = children.length;
            while (i < length) {
                who = children[i++];gototop
                if (who.nodeType !== 1)
                    continue; // element nodes only
                if (deepCss(who, "position") !== "static") {
                    temp = deepCss(who, "z-index");
                    if (temp === "auto") { // z-index is auto, so not a new stacking context
                        temp = highZ(who);
                    } else {
                        temp = parseInt(temp, 10) || 0;
                    }
                } else { // non-positioned element, so not a new stacking context
                    temp = highZ(who);
                }
                if (temp > max && temp <= limit)
                    max = temp;
            }
            return max;
        };
        
        this.construct(options);
    };
    $(document).ready(function(){
        new plgSysTopOfThePage(window.plg_system_topofthepage_options);
    });    
})(jQuery);