<?php
 /**
 * Horizontal scrolling announcements
 *
 * @package 	Horizontal scrolling announcements
 * @subpackage 	mod_horizontal_scrolling_announcements
 * @version   	3.7
 * @author    	Gopi Ramasamy
 * @copyright 	Copyright (C) 2010 - 2020 www.gopiplus.com, LLC
 * @license   	GNU General Public License version 2 or later; see LICENSE.txt
 *
 * http://www.gopiplus.com/extensions/2018/02/horizontal-scrolling-announcements-joomla-module/
 */ 

defined('_JEXEC') or die;

abstract class HorizontalScrollingAnnouncementsHelper
{
	public static function loadScripts(&$params)
	{
		$doc = JFactory::getDocument();
		$jquery = $params->get('hsa_jquery', 'NO');
		if($jquery == "YES") {
			$doc->addScript(JURI::Root(true).'/modules/mod_horizontal_scrolling_announcements/script/jquery.min.js');
		}
		$doc->addScript(JURI::Root(true).'/modules/mod_horizontal_scrolling_announcements/script/jquery.marquee.min.js');
	}
	
	public static function getAnnouncementsInfo(&$params)
	{
		$items	= array();
		$j = 0;
		for($i=1; $i<=10; $i++)
		{
			$hsa_news = "hsa_news" . $i;
			$hsa_news_txt = $params->get($hsa_news, '');
			
			$hsa_link = "hsa_link" . $i;
			$hsa_link_txt = $params->get($hsa_link, '');
			
			if($hsa_news_txt <> "")
			{
				$items[$j] = new \stdClass;
				$items[$j]->hsa_news	= $hsa_news_txt;
				$items[$j]->hsa_link	= $hsa_link_txt;
				$j = $j+1;
			}
		}
		return $items;
    }
}