<?php
if(!defined('_VALID_MOS') && !defined('_JEXEC')) die('Direct Access to '.basename(__FILE__).' is not allowed.');

/**
 * @package RealEstateManager
 * @copyright 2012 by OrdaSoft
 * @author Andrey Kvasnevskiy - OrdaSoft (akbet@mail.ru)
 * @description Search RealEstate for RealEstateManager Component
 * Homepage: http://www.ordasoft.com
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

defined('DS') or define('DS', DIRECTORY_SEPARATOR);
require_once ( JPATH_BASE .'/administrator/components/com_realestatemanager/realestatemanager.class.others.php');
require_once ( JPATH_BASE .'/administrator/components/com_realestatemanager/realestatemanager.class.others.php' );
require_once ( JPATH_BASE .'/components/com_realestatemanager/functions.php' );
require_once ( JPATH_BASE .'/components/com_realestatemanager/realestatemanager.main.categories.class.php' );
$doc = JFactory::getDocument();
$doc->addStyleSheet( JURI::base(true) .'/components/com_realestatemanager/includes/realestatemanager.css');
$doc->addStyleSheet( JURI::base(true) .'/components/com_realestatemanager/includes/jQuerREL-ui.css');

$jinput = JFactory::getApplication()->input;
$database = JFactory::getDBO();
// load language
$languagelocale = "";
$query = "SELECT l.title, l.lang_code, l.sef ";
$query .= "FROM #__rem_const_languages as cl ";
$query .= "LEFT JOIN #__rem_languages AS l ON cl.fk_languagesid=l.id ";
$query .= "LEFT JOIN #__rem_const AS c ON cl.fk_constid=c.id ";
$query .= "GROUP BY  l.title";
$database->setQuery($query);
$languages = $database->loadObjectList();

$lang = JFactory::getLanguage();
foreach ($lang->getLocale() as $locale) {
    foreach ($languages as $language) {
        if (strtolower($locale) == strtolower($language->title)
            || strtolower($locale) == strtolower($language->lang_code)
            || strtolower($locale) == strtolower($language->sef) ) {
            $mosConfig_lang = $locale;
            $languagelocale = $language->lang_code;
            break;
        }
    }
}

if ($languagelocale == '')
    $languagelocale = "en-GB";

global $langContent, $realestatemanager_configuration;
$langContent = substr($languagelocale, 0, 2);

$query = "SELECT c.const, cl.value_const ";
$query .= "FROM #__rem_const_languages as cl ";
$query .= "LEFT JOIN #__rem_languages AS l ON cl.fk_languagesid=l.id ";
$query .= "LEFT JOIN #__rem_const AS c ON cl.fk_constid=c.id ";
$query .= "WHERE l.lang_code = '$languagelocale'";
$database->setQuery($query);
$langConst = $database->loadObjectList();

foreach ($langConst as $item) {
   if(!defined($item->const) )  define($item->const, $item->value_const);
}


if(!function_exists('sefRelToAbs')){
    function sefRelToAbs($value){
        //Need check!!!
        //Replace all &amp; with & as the router doesn't understand &amp;
        $url = str_replace('&amp;', '&', $value);
        if(substr(strtolower($url),0,9) != "index.php") return $url;
        $uri    = JURI::getInstance();
        $prefix = $uri->toString(array('scheme', 'host', 'port'));
        return $prefix.JRoute::_($url);
    }
}

global $mosConfig_absolute_path, $mosConfig_allowUserRegistration, $mosConfig_lang, $database, $mosConfig_live_site;
require_once('./components/com_realestatemanager/compat.joomla1.5.php');

$label_propertyid = $params->get('label_propertyid', 0);
$label_description = $params->get('label_description', 0);
$label_title = $params->get('label_title', 0);
$label_country = $params->get('label_country', 0);
$label_address = $params->get('label_address', 0);
$label_region = $params->get('label_region', 0);
$label_city = $params->get('label_city', 0);
$label_zipcode = $params->get('label_zipcode', 0);
$label_owner = $params->get('label_owner', 0);
$label_rooms = $params->get('label_rooms', 0);
$label_bathrooms = $params->get('label_bathrooms', 0);
$label_bedrooms = $params->get('label_bedrooms', 0);
$label_garages = $params->get('label_garages', 0);
$label_build_year = $params->get('label_build_year', 0);
$label_contacts = $params->get('label_contacts', 0);
$label_agent = $params->get('label_agent', 0);
$label_house_size = $params->get('label_house_size', 0);
$label_lot_size = $params->get('label_lot_size', 0);
$label_search_exactly = $params->get('label_search_exactly', 0);

$moduleclass_sfx=$params-> get('moduleclass_sfx');
$ItemId_tmp_from_params=$params->get ('ItemId');

$searchLayout = $params->get('search_result_layout');

$database->setQuery("SELECT id FROM #__menu WHERE link LIKE'%option=com_realestatemanager%' AND params LIKE '%back_button%'");
$ItemId_tmp_from_db = $database->loadResult();
if($ItemId_tmp_from_params=="") $ItemId=$ItemId_tmp_from_db; else $ItemId=$ItemId_tmp_from_params;

//search string
$search_val = $jinput->getRaw('searchtext') ? trim($jinput->getRaw('searchtext')) : '';
$searchtext = '<input class="inputbox" type="text" name="searchtext" value="'.$search_val.'" size="20" maxlength="20"/>';

//categories
if (isset($langContent)) {
    $lang = $langContent;
    $query = "SELECT lang_code FROM #__languages WHERE sef = '$lang'";
    $database->setQuery($query);
    $lang = $database->loadResult();
    $lang = " c.language = '$lang' or c.language like 'all' or c.language like '' "
     . " or c.language like '*' or c.language is null ";
} else {
    $lang = "";
}

$category_val = $jinput->getRaw('catid') ? trim($jinput->getRaw('catid')) : _REALESTATE_MANAGER_LABEL_ALL;
$categories[] = mosHTML :: makeOption(_REALESTATE_MANAGER_LABEL_ALL, _REALESTATE_MANAGER_LABEL_ALL);
$clist = com_house_categoryTreeList(0, '', true, $categories, $category_val, $lang);

//select list for listing type
$listing_type_val = $jinput->getRaw('listing_type') ? trim($jinput->getRaw('listing_type')) : _REALESTATE_MANAGER_LABEL_ALL;
$listing_type[]=mosHtml::makeOption(_REALESTATE_MANAGER_LABEL_ALL,_REALESTATE_MANAGER_LABEL_ALL);
$listing_type[]=mosHtml::makeOption(1,_REALESTATE_MANAGER_OPTION_FOR_RENT);
$listing_type[]=mosHtml::makeOption(2,_REALESTATE_MANAGER_OPTION_FOR_SALE);
$listing_type_list = mosHTML :: selectList($listing_type, 'listing_type',
 'class="inputbox modSearchSelect" size="1" style="width: 115px"', 'value', 'text', $listing_type_val);
$params->def('listing_type_list',$listing_type_list);

//select list for listing status
$listing_status_val = $jinput->getRaw('listing_status') ? trim($jinput->getRaw('listing_status')) : _REALESTATE_MANAGER_LABEL_ALL;
$listing_status[] = mosHtml::makeOption(_REALESTATE_MANAGER_LABEL_ALL,_REALESTATE_MANAGER_LABEL_ALL);
$listing_status1=explode(',',_REALESTATE_MANAGER_OPTION_LISTING_STATUS);
$i=1; foreach($listing_status1 as $listing_status2) {$listing_status[]=mosHtml::makeOption($i,$listing_status2);$i++;}
$listing_status_list = mosHTML::selectList($listing_status, 'listing_status',
 'class="inputbox modSearchSelect" size="1" style="width: 115px"', 'value', 'text', $listing_status_val);
$params->def('listing_status_list', $listing_status_list);

//******************************************** numbers rooms list *********************************
$rooms_num_val = $jinput->getRaw('rooms_num') ? trim($jinput->getRaw('rooms_num')) : _REALESTATE_MANAGER_LABEL_ALL;
$numbers = explode(',', _REALESTATE_MANAGER_NUMBERS_BBROOMS);
$rooms[] = mosHtml::makeOption(_REALESTATE_MANAGER_LABEL_ALL, _REALESTATE_MANAGER_LABEL_ALL);
$count = 1;
foreach($numbers as $num){
    $rooms[] = mosHtml::makeOption($count, $num);
    $count++;
}
$rooms_list = mosHTML::selectList($rooms, 'rooms_num', 'class="inputbox" size="1" style="width: 115px"', 'value', 'text', $rooms_num_val);
$params->def('rooms_num', $rooms_list);
//******************************************** end numbers rooms list *********************************
//******************************************** numbers bathrooms list *********************************
$bathrooms_num_val = $jinput->getRaw('bathrooms_num') ? trim($jinput->getRaw('bathrooms_num')) : _REALESTATE_MANAGER_LABEL_ALL;
$bathrooms[] = mosHtml::makeOption(_REALESTATE_MANAGER_LABEL_ALL, _REALESTATE_MANAGER_LABEL_ALL);
$count = 1;
foreach($numbers as $num){
    $bathrooms[] = mosHtml::makeOption($count, $num);
    $count++;
}
$bathrooms_list = mosHTML::selectList($bathrooms, 'bathrooms_num', 'class="inputbox" size="1" style="width: 115px"', 'value', 'text', $bathrooms_num_val);
$params->def('bathrooms_num', $bathrooms_list);
//******************************************** end numbers bathrooms list *********************************
//******************************************** numbers bedrooms list *********************************
$bedrooms_num_val = $jinput->getRaw('bedrooms_num') ? trim($jinput->getRaw('bedrooms_num')) : _REALESTATE_MANAGER_LABEL_ALL;
$bedrooms[] = mosHtml::makeOption(_REALESTATE_MANAGER_LABEL_ALL, _REALESTATE_MANAGER_LABEL_ALL);
$count = 1;
foreach($numbers as $num){
    $bedrooms[] = mosHtml::makeOption($count, $num);
    $count++;
}
$bedrooms_list = mosHTML::selectList($bedrooms, 'bedrooms_num', 'class="inputbox" size="1" style="width: 115px"', 'value', 'text', $bedrooms_num_val);
$params->def('bedrooms_num', $bedrooms_list);
//******************************************** end numbers bedrooms list *********************************

// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! Vitaliy, 190726, START:
//******************************************** numbers garages list *********************************
$garage_num_val = $jinput->getRaw('garages_num') ? trim($jinput->getRaw('garages_num')) : _REALESTATE_MANAGER_LABEL_ALL;
$garages[] = mosHtml::makeOption(_REALESTATE_MANAGER_LABEL_ALL, _REALESTATE_MANAGER_LABEL_ALL);
$count = 1;
foreach($numbers as $num){
    $garages[] = mosHtml::makeOption($count, $num);
    $count++;
}
$garages_list = mosHTML::selectList($garages, 'garages_num', 'class="inputbox" size="1" style="width: 115px"', 'value', 'text', $garage_num_val);
$params->def('garages_num', $garages_list);
//******************************************** end numbers garages list *********************************
//******************************************** numbers build years list *********************************
$build_year_val = $jinput->getRaw('year') ? trim($jinput->getRaw('year')) : _REALESTATE_MANAGER_LABEL_ALL;
$build_years[] = mosHtml::makeOption(_REALESTATE_MANAGER_LABEL_ALL, _REALESTATE_MANAGER_LABEL_ALL);
for ($year = intval(date('Y')) + 1; 1900 < $year; $year--) {
    if ($year == intval(date('Y')) + 1) {
        $year_plus = $year;
    } else {
        $year_plus = $year . '+';
    }
    $build_years[] = mosHtml::makeOption($year, $year_plus);
}
$build_years_list = mosHTML::selectList($build_years, 'year', 'class="inputbox" size="1" style="width: 115px"', 'value', 'text', $build_year_val);
$params->def('year', $build_years_list);
//******************************************** end numbers build years list *********************************
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! Vitaliy, 190726, END.

//******************************************** country list start *********************************
if($realestatemanager_configuration['show_country_region_city_as_text_field']==0){

            $countrys_and_regions = mosRealEstateManagerOthers::getElementsArray('countrys_and_regions.txt');
            $regions_and_citys = mosRealEstateManagerOthers::getElementsArray('regions_and_citys.txt');

            $temp[2] = $countrys_and_regions[0];
            $temp[3] = $countrys_and_regions[1];
            $temp[4] = $regions_and_citys[0];
            $temp[5] = $regions_and_citys[1];

            //hcountry Need for region search if search "for country" set  to NONE
            $hcountry = $jinput->getRaw('country') ? $jinput->getRaw('country') : _REALESTATE_MANAGER_LABEL_ALL;
            if(trim($hcountry) == ''
            || trim($hcountry) == 'all'
            || trim($hcountry) == _REALESTATE_MANAGER_LABEL_ALL){
                $countryList = $countrys_and_regions[0];

                foreach ($countryList as $country) {
                    if (trim($country) != ''){
                        $hcountry = trim($country);
                        break ;
                    }
                }
            }

            if($label_country==0){

                $hcountry = $jinput->getRaw('country') ? $jinput->getRaw('country') : _REALESTATE_MANAGER_LABEL_ALL;

                if(trim($hcountry) == '' || trim($hcountry) == 'all' || trim($hcountry) == _REALESTATE_MANAGER_LABEL_ALL ){
                    $hcountry  = _REALESTATE_MANAGER_LABEL_ALL;
                }

                $countrys[] = mosHtml::makeOption(_REALESTATE_MANAGER_LABEL_ALL, _REALESTATE_MANAGER_LABEL_ALL);

                $countryList = $countrys_and_regions[0];

                foreach ($countryList as $country) {
                    if (trim($country) != ''){
                        $countrys[] = mosHtml::makeOption(trim($country), trim($country));
                    }
                }

                if (!in_array($hcountry, $countrys_and_regions[0])){
                    if($hcountry != _REALESTATE_MANAGER_LABEL_ALL){
                        $countrys[] = mosHtml::makeOption($hcountry, $hcountry);
                    }
                }

                $country = mosHTML::selectList($countrys, 'country', 'class="inputbox" size="1" onchange=rem_changedCountry_mod(this)', 'value', 'text', $hcountry);

            } elseif($label_country==2){
                
                $country = '<input type="hidden" name="country" class="inputbox" size="1" style="width: 140px" value="' ._REALESTATE_MANAGER_LABEL_ALL .'" />';
            } else{
                $country = "";
            }

        $params->def('country', $country);
        //******************************************** country list end *********************************
        //******************************************** region list start *********************************
        //hregion Need for city search if search "for region" set  to NONE
            $hregion = $jinput->getRaw('region') ? $jinput->getRaw('region') : _REALESTATE_MANAGER_LABEL_ALL;

            if(trim($hregion) == ''
            || trim($hregion) == 'all'
            || trim($hregion) == _REALESTATE_MANAGER_LABEL_ALL){
                $regionList = $regions_and_citys[0];

                foreach ($regionList as $region) {
                    if (trim($region) != ''){
                        $hregion = trim($region);
                        break ;
                    }
                }
            }

            if($label_region==0){

            if(trim($hregion) == ''
            || trim($hregion) == 'all' || trim($hregion) == _REALESTATE_MANAGER_LABEL_ALL ){
              $hregion  = _REALESTATE_MANAGER_LABEL_ALL;
            }

            $regions[] = mosHtml::makeOption(_REALESTATE_MANAGER_LABEL_ALL, _REALESTATE_MANAGER_LABEL_ALL);

            if(in_array($hcountry, $countrys_and_regions[0])){
                $countrys_and_regions_tmp = array_flip($countrys_and_regions[0]) ;
                $countryIndex = $countrys_and_regions_tmp[$hcountry];
                $regionList = $countrys_and_regions[1][$countryIndex];

                foreach ($regionList as $region) {
                    if (trim($region) != ''){
                        $regions[] = mosHtml::makeOption(trim($region), trim($region));
                    }
                }
            }else{
                if($hregion  != _REALESTATE_MANAGER_LABEL_ALL){
                    $regions[] = mosHtml::makeOption(trim($hregion), trim($hregion));
                }
            }

            $region = mosHTML::selectList($regions, 'region', 'class="inputbox" size="1" onchange=rem_changedRegion_mod(this)', 'value', 'text', $hregion);

        } elseif($label_region==2){

            $region = '<input type="hidden" name="region" class="inputbox" size="1" style="width: 140px" value="' ._REALESTATE_MANAGER_LABEL_ALL .'" />';
        } else{
            $region = "";
        }

        $params->def('region', $region);

        //******************************************** end region list **************************************
        //******************************************** city list ********************************************
    $hcity = $jinput->getRaw('hity') ? $jinput->getRaw('city') : _REALESTATE_MANAGER_LABEL_ALL;
    if(in_array($hregion, $regions_and_citys[0])){
        $regions_and_citys_tmp = array_flip($regions_and_citys[0]) ;
        $regionIndex = $regions_and_citys_tmp[$hregion];
        $cityList = $regions_and_citys[1][$regionIndex];

        foreach ($cityList as $city) {
            if (trim($city) != ''){
              $citys[] = mosHtml::makeOption(trim($city), trim($city));
            }
        }
    }else{
        if($hcity  != _REALESTATE_MANAGER_LABEL_ALL){
            $citys[] = mosHtml::makeOption($hcity, $hcity);
        }
    }

    $citys[] = mosHtml::makeOption(_REALESTATE_MANAGER_LABEL_ALL, _REALESTATE_MANAGER_LABEL_ALL);
    $city = mosHTML::selectList($citys, 'city', 'class="inputbox" size="1" style="width: 115px"',
         'value', 'text', $hcity);

    $params->def('city', $city);
}
        //******************************************** end city list *****************************************
        //*********************************** add extra6,extra7,extra8,extra9,extra10 ************************
for($i=6;$i<=10;$i++){
  if($params->get('label_show_custom_dropdown_field_'. $i) == 0){
  $extraOption = array();
  $index = 'extra'.$i;

  $extrafield_val = $jinput->getRaw('extra'.$i) ? $jinput->getRaw('extra'.$i) : _REALESTATE_MANAGER_LABEL_ALL;

  $extraOption[] = mosHtml::makeOption(_REALESTATE_MANAGER_LABEL_ALL, _REALESTATE_MANAGER_LABEL_ALL);
  $name = "_REALESTATE_MANAGER_EXTRA".$i."_SELECTLIST";
  $extra = explode(',', constant($name));
  $j = 1;
  foreach($extra as $extr){
    $extraOption[] = mosHTML::makeOption($j, $extr);
    $j++;
  }
  $extra_list[$i] = mosHTML::selectList($extraOption, 'extra'.$i,
   'class="inputbox" size="1" style="width: 115px"', 'value', 'text', $extrafield_val);
    $params->def('extrafield'.$i, $extra_list[$i]);
  }
}
        //*************************** end add extra6,extra7,extra8,extra9,extra10 *****************************
//price
$query = "SELECT MAX(price+0) FROM #__rem_houses";
$database->setQuery($query);
$max_price = $database->loadResult();
// $prices = $database->loadColumn();
// rsort($prices,SORT_NUMERIC);

//lot size
$query = "SELECT MAX(lot_size+0) FROM #__rem_houses";
$database->setQuery($query);
$max_lot_size = $database->loadResult();
$lot_size = $database->loadColumn();
rsort($lot_size,SORT_NUMERIC);

//lot size
$query = "SELECT MAX(house_size+0) FROM #__rem_houses";
$database->setQuery($query);
$max_house_size = $database->loadResult();
$house_size = $database->loadColumn();
rsort($house_size,SORT_NUMERIC);

?>
<?php
if( !function_exists('filterDateSearchMod') ) {
    function filterDateSearchMod() {
        global $realestatemanager_configuration;
        $DateToFormat = str_replace("d", 'dd', (str_replace("m", 'mm', (str_replace("Y", 'yy', (str_replace('%', '', $realestatemanager_configuration['date_format'])))))));
        return $DateToFormat;
    }
}
?>

<?php
if(checkJavaScriptIncludedRE("jQuerREL-1.2.6.js") === false ) {
  $doc->addScript(JURI::root(true) . '/components/com_realestatemanager/lightbox/js/jQuerREL-1.2.6.js');
}
 ?>

<?php
if(checkJavaScriptIncludedRE("jQuerREL-ui.js") === false ) {
  $doc->addScript(JURI::root(true) . '/components/com_realestatemanager/includes/jQuerREL-ui.js');
}
?>

<?php
    //price, lot_size, house_size values, dates from-to
    $pricefrom_val = $jinput->getRaw('pricefrom2') ? $jinput->getRaw('pricefrom2') : 0;
    $priceto_val = $jinput->getRaw('priceto2') ? $jinput->getRaw('priceto2') : $max_price;

    $lotsizefrom_val = $jinput->getRaw('lotsizefrom2') ? $jinput->getRaw('lotsizefrom2') : 0;
    $lotsizeto_val = $jinput->getRaw('lotsizeto2') ? $jinput->getRaw('lotsizeto2') : $max_lot_size;

    $housesizefrom_val = $jinput->getRaw('housesizefrom2') ? $jinput->getRaw('housesizefrom2') : 0;
    $housesizeto_val = $jinput->getRaw('housesizeto2') ? $jinput->getRaw('housesizeto2') : $max_house_size;

    $search_date_from_val =  $jinput->getRaw('search_date_from') ? $jinput->getRaw('search_date_from') : '';
    $search_date_until_val =  $jinput->getRaw('search_date_until') ? $jinput->getRaw('search_date_until') : '';

?>

<noscript>Javascript is required to use Real Estate Manager <a href="http://ordasoft.com/Real-Estate-Manager/realestatemanager-basic-and-pro-feature-comparison.html">Real estate manager Joomla extension for Real Estate Brokers, Real Estate Companies and other Enterprises selling Real estate
</a>, <a href="http://ordasoft.com/Real-Estate-Manager/realestatemanager-basic-and-pro-feature-comparison.html">Real Estate Manager create own real estate web portal for sell, rent,  buy real estate and property</a></noscript>

<script>
jQuerREL(function() {
    jQuerREL( "#search_date_from_mod, #search_date_until_mod" ).datepicker(
    {
    minDate: "+0",
    dateFormat: "<?php echo filterDateSearchMod(); ?>",
    });
});
</script>
<!-- price slider -->
<script type="text/javascript">

       jQuerREL(function() {
            jQuerREL("#rem_slider_mod").slider({
                min: 0,
                max: <?php echo $max_price; ?>,
                values: [<?php echo $pricefrom_val; ?>,<?php echo $priceto_val; ?>],
                range: true,
                stop: function(event, ui) {
                    jQuerREL("input#pricefrom").val(jQuerREL("#rem_slider_mod").slider("values",0));
                    jQuerREL("input#priceto").val(jQuerREL("#rem_slider_mod").slider("values",1));
                },
                slide: function(event, ui){
                    jQuerREL("input#pricefrom").val(jQuerREL("#rem_slider_mod").slider("values",0));
                    jQuerREL("input#priceto").val(jQuerREL("#rem_slider_mod").slider("values",1));
                }
            });

            jQuerREL("input#pricefrom").change(function(){
                var value1=jQuerREL("input#pricefrom").val();
                var value2=jQuerREL("input#priceto").val();

                if(parseInt(value1) > parseInt(value2)){
                    value1 = value2;
                    jQuerREL("input#pricefrom").val(value1);
                }
                jQuerREL("#rem_slider_mod").slider("values",0,value1);
            });

            jQuerREL("input#priceto").change(function(){
                var value1=jQuerREL("input#pricefrom").val();
                var value2=jQuerREL("input#priceto").val();
                if(parseInt(value1) > parseInt(value2)){
                    value2 = value1;
                    jQuerREL("input#priceto").val(value2);
                }
                jQuerREL("#rem_slider_mod").slider("values",1,value2);
            });
        });
    </script>
<!-- end price slider -->
<!--****************************add slider lot size*********************************-->
<script type="text/javascript">

       jQuerREL(function() {
            jQuerREL("#rem_lot_size_slider_mod").slider({
                min: 0,
                max: <?php echo $max_lot_size; ?>,
                values: [<?php echo $lotsizefrom_val; ?>,<?php echo $lotsizeto_val; ?>],
                range: true,
                stop: function(event, ui) {
                    jQuerREL("input#lotsizefrom").val(jQuerREL("#rem_lot_size_slider_mod").slider("values",0));
                    jQuerREL("input#lotsizeto").val(jQuerREL("#rem_lot_size_slider_mod").slider("values",1));
                },
                slide: function(event, ui){
                    jQuerREL("input#lotsizefrom").val(jQuerREL("#rem_lot_size_slider_mod").slider("values",0));
                    jQuerREL("input#lotsizeto").val(jQuerREL("#rem_lot_size_slider_mod").slider("values",1));
                }
            });

            jQuerREL("input#lotsizefrom").change(function(){
                var value1=jQuerREL("input#lotsizefrom").val();
                var value2=jQuerREL("input#lotsizeto").val();

                if(parseInt(value1) > parseInt(value2)){
                    value1 = value2;
                    jQuerREL("input#lotsizefrom").val(value1);
                }
                jQuerREL("#rem_lot_size_slider_mod").slider("values",0,value1);
            });

            jQuerREL("input#lotsizeto").change(function(){
                var value1=jQuerREL("input#lotsizefrom").val();
                var value2=jQuerREL("input#lotsizeto").val();
                if(parseInt(value1) > parseInt(value2)){
                    value2 = value1;
                    jQuerREL("input#lotsizeto").val(value2);
                }
                jQuerREL("#rem_lot_size_slider_mod").slider("values",1,value2);
            });
        });
    </script>
<!--****************************add slider lot size*********************************-->

<!--****************************add slider house size*********************************-->
<script type="text/javascript">

       jQuerREL(function() {
            jQuerREL("#rem_house_size_slider_mod").slider({
                min: 0,
                max: <?php echo $max_house_size; ?>,
                values: [<?php echo $housesizefrom_val; ?>,<?php echo $housesizeto_val; ?>],
                range: true,
                stop: function(event, ui) {
                    jQuerREL("input#housesizefrom").val(jQuerREL("#rem_house_size_slider_mod").slider("values",0));
                    jQuerREL("input#housesizeto").val(jQuerREL("#rem_house_size_slider_mod").slider("values",1));
                },
                slide: function(event, ui){
                    jQuerREL("input#housesizefrom").val(jQuerREL("#rem_house_size_slider_mod").slider("values",0));
                    jQuerREL("input#housesizeto").val(jQuerREL("#rem_house_size_slider_mod").slider("values",1));
                }
            });

            jQuerREL("input#housesizefrom").change(function(){
                var value1=jQuerREL("input#housesizefrom").val();
                var value2=jQuerREL("input#housesizeto").val();

                if(parseInt(value1) > parseInt(value2)){
                    value1 = value2;
                    jQuerREL("input#housesizefrom").val(value1);
                }
                jQuerREL("#rem_house_size_slider_mod").slider("values",0,value1);
            });

            jQuerREL("input#lotsizeto").change(function(){
                var value1=jQuerREL("input#housesizefrom").val();
                var value2=jQuerREL("input#housesizeto").val();
                if(parseInt(value1) > parseInt(value2)){
                    value2 = value1;
                    jQuerREL("input#housesizeto").val(value2);
                }
                jQuerREL("#rem_house_size_slider_mod").slider("values",1,value2);
            });
        });
    </script>
<!--****************************add slider house size*********************************-->

<div class="com_realestatemanager<?php echo $moduleclass_sfx;?>">
    <div id="rem_mod_search" style="display:inline-block;">
        <form action="<?php echo sefRelToAbs(
          "index.php?option=com_realestatemanager&amp;task=search&amp;catid=0&amp;Itemid=".$ItemId); ?>" method="get" name="mod_realestatlibsearchForm">

            <div style="display:inline-block; margin-right:10px;">
            <?php
            if(($params->get('label_search_keyword') == 0)) {
            ?>
                <div class="search_houses">
                    <div class="search_title">
                        <?php echo _REALESTATE_MANAGER_LABEL_SEARCH_KEYWORD; ?>
                    </div>
                    <?php echo $searchtext; ?>
                </div>
            <?php
            }

            if(($params->get('label_category') == 0)) {
            ?>
                <div class="col_box">
                    <span><?php echo _REALESTATE_MANAGER_LABEL_CATEGORY; ?></span>
                    <?php echo $clist; ?>
                </div>
            </div>
            <?php
            }
            ?>

            <?php if($params->get('label_check_in') == 0 || $params->get('label_check_out') == 0){ ?>
            <div class="search_rent" style="display:inline-block; margin-right:10px;">
            <?php
            if($params->get('label_check_in') == 0){
            ?>
                <div class="box_from" >
                    <span class="col_01"><?php echo _REALESTATE_MANAGER_LABEL_RENT_REQUEST_FROM; ?></span>
                    <input type="text" id="search_date_from_mod" name="search_date_from" value="<?php echo $search_date_from_val; ?>">
                </div>
            <?php
            }
            ?>
            <?php
            if($params->get('label_check_out') == 0){
            ?>
                <div class="box_from" >
                    <span class="col_01"><?php echo _REALESTATE_MANAGER_LABEL_RENT_REQUEST_UNTIL; ?></span>
                    <input type="text" id="search_date_until_mod" name="search_date_until" value="<?php echo $search_date_until_val; ?>">
                </div>
            <?php
            }
            ?>
            </div>
            <?php } if($params->get('label_price') == 0){ ?>
            <div class="col_box_1" style="display:inline-block; margin-right:10px;">
                <span class="price_label"><?php echo _REALESTATE_MANAGER_LABEL_PRICE; ?></span>
                <div id="rem_slider_mod" class="ui-slider ui-slider-horizontal ui-widget
                 ui-widget-content ui-corner-all"></div>
                <div class="pricefrom_2">
                    <span><?php echo _REALESTATE_MANAGER_LABEL_FROM; ?></span>
                    <input type="text" id="pricefrom" name="pricefrom2" value="<?php echo $pricefrom_val; ?>"/>
                </div>
                <div class="priceto_2">
                    <span><?php echo _REALESTATE_MANAGER_LABEL_TO; ?></span>
                    <input type="text" id="priceto" name="priceto2" value="<?php echo $priceto_val; ?>"/>
                </div>
                <div style="clear: both;"></div>
            </div>

            <!-- add lot size slider -->
            <?php
            }
            if($label_lot_size == 0){ ?>
            <div class="col_box_1" style="display:inline-block; margin-right:10px;">
                <span class="price_label"><?php echo _REALESTATE_MANAGER_LABEL_LOT_SIZE; ?></span>
                <div id="rem_lot_size_slider_mod" class="ui-slider ui-slider-horizontal ui-widget
                 ui-widget-content ui-corner-all"></div>
                <div class="pricefrom_2">
                    <span><?php echo _REALESTATE_MANAGER_LABEL_FROM; ?></span>
                    <input type="text" id="lotsizefrom" name="lotsizefrom2" value="<?php echo $lotsizefrom_val; ?>"/>
                </div>
                <div class="priceto_2">
                    <span><?php echo _REALESTATE_MANAGER_LABEL_TO; ?></span>
                    <input type="text" id="lotsizeto" name="lotsizeto2" value="<?php echo $lotsizeto_val; ?>"/>
                </div>
                <div style="clear: both;"></div>
            </div>
            <!-- end add lot size slider -->

            <!-- add lot size slider -->
            <?php
            }
            if($params->get('label_house_size') == 0) {
            ?>
            <div class="col_box_1" style="display:inline-block; margin-right:10px;">
                <span class="price_label"><?php echo _REALESTATE_MANAGER_LABEL_HOUSE_SIZE; ?></span>
                <div id="rem_house_size_slider_mod" class="ui-slider ui-slider-horizontal ui-widget
                 ui-widget-content ui-corner-all"></div>
                <div class="pricefrom_2">
                    <span><?php echo _REALESTATE_MANAGER_LABEL_FROM; ?></span>
                    <input type="text" id="housesizefrom" name="housesizefrom2" value="<?php echo $housesizefrom_val; ?>"/>
                </div>
                <div class="priceto_2">
                    <span><?php echo _REALESTATE_MANAGER_LABEL_TO; ?></span>
                    <input type="text" id="housesizeto" name="housesizeto2" value="<?php echo $housesizeto_val; ?>"/>
                </div>
                <div style="clear: both;"></div>
            </div>
            <?php } ?>
            <!-- end add lot size slider -->

            <div class="rel_mod_search_select_box" >
              <?php
              if($params->get('listing_type_list') == 0){?>
                <div class="col_box_2">
                    <span><?php echo _REALESTATE_MANAGER_LABEL_LISTING_TYPE; ?></span>
                    <?php echo $listing_type_list; ?>
                </div>
      <?php }?>
      <?php if($params->get('listing_status_list') == 0){?>
                <div class="col_box_2">
                    <span><?php echo _REALESTATE_MANAGER_LABEL_LISTING_STATUS; ?></span>
                    <?php echo $listing_status_list; ?>
                </div>
            <?php }?>
        <?php if($params->get('label_rooms_numbers') == 0){?>
                <div class="col_box_2">
                    <span><?php echo _REALESTATE_MANAGER_LABEL_ROOMS; ?></span>
                    <?php echo $rooms_list; ?>
                </div>
            <?php } ?>

    <?php if($params->get('label_bathrooms_numbers') == 0){?>
                <div class="col_box_2">
                    <span><?php echo _REALESTATE_MANAGER_LABEL_BATHROOMS; ?></span>
                    <?php echo $bathrooms_list; ?>
                </div>
            <?php } ?>
    <?php if($params->get('label_bedrooms_numbers') == 0){?>
                <div class="col_box_2">
                    <span><?php echo _REALESTATE_MANAGER_LABEL_BEDROOMS; ?></span>
                    <?php echo $bedrooms_list; ?>
                </div>
            <?php } ?>
            
            <!-- // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! Vitaliy, 190726, START: -->
            
            <?php if($label_garages == 0){?>
                <div class="col_box_2">
                    <span><?php echo _REALESTATE_MANAGER_LABEL_GARAGES; ?></span>
                    <?php echo $garages_list; ?>
                </div>
            <?php } ?>


            <?php if($label_build_year == 0){?>
                <div class="col_box_2">
                    <span><?php echo _REALESTATE_MANAGER_LABEL_BUILD_YEAR; ?></span>
                    <?php echo $build_years_list; ?>
                </div>
            <?php } ?>
            
            <!-- // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! Vitaliy, 190726, END. -->
            
    <!--*********************************** contry, region, city START: ***********************************-->
    <?php
    if($realestatemanager_configuration['show_country_region_city_as_text_field'] == 0) { ?>
        <?php if($label_country == 0){?>
            <div class="col_box_2">
                <span><?php echo _REALESTATE_MANAGER_LABEL_COUNTRY; ?></span>
                <?php echo $params->get('country'); ?>
            </div>

        <?php
        } else if($label_country == 2  ) {
            // echo  '<input type="hidden" name="hcountry"  value="' ._REALESTATE_MANAGER_LABEL_ALL .'" />';
            echo $params->get('country');
        }

        if($label_country == 0 || $label_country == 2  ) {
            ?>
            <script type="text/javascript">
            <?php
            $countrys = $countrys_and_regions[0];
            $regions  = $countrys_and_regions[1];
            $regs     = $regions_and_citys[0];
            $citys    = $regions_and_citys[1];

            echo 'var countrysregions = [];';

        for($c=0; $c<count($countrys); $c++){
        $countrys[$c]='\''.$countrys[$c].'\'';
        foreach($regions[$c] as $temp=>$region)
          $regions[$c][$temp]='\''.$region.'\'';
        echo 'var temp=new Array("'._REALESTATE_MANAGER_LABEL_ALL.'",'.implode(',',$regions[$c]).");\n";
        echo 'countrysregions['.$c."]=temp;\n";
      }
      echo 'var countrys=new Array('.implode(',',$countrys).');';

      echo 'var regionscitys = [];';

      for($c=0; $c<count($regs); $c++){
        $regs[$c]='\''.$regs[$c].'\'';
        foreach($citys[$c] as $temp=>$city)
          $citys[$c][$temp]='\''.$city.'\'';
        echo 'var temp=new Array("'._REALESTATE_MANAGER_LABEL_ALL.'",'.implode(',',$citys[$c]).");\n";
        echo 'regionscitys['.$c."]=temp;\n";
      }
      echo 'var regs=new Array('.implode(',',$regs).');';

    ?>

      function rem_changedCountry_mod(country){

        var id = rem_in_array_select_mod(country.value,countrys);
        var region = document.getElementsByName('region')[0];

        if(typeof(region) == 'undefined'){
          return;
        }

        rem_clearSelectList_mod('region');
        rem_clearSelectList_mod('city');
        rem_setAllselect_mod('city');

        if(country.value=='<?php echo _REALESTATE_MANAGER_LABEL_ALL;?>'){
          rem_setAllselect_mod('region');
          return;
        }

        for(var c=0;c<countrysregions[id].length;c++){
            rem_createOptionList_mod('region', countrysregions[id][c],countrysregions[id][c]);
        }
      }
      //end region
      //citys
      function rem_changedRegion_mod(region){
        var id = rem_in_array_select_mod(region.value,regs);
        var city = document.getElementsByName('city')[0];

        if(typeof(city) == 'undefined'){
          return;
        }

        rem_clearSelectList_mod('city');

        if(region.value=='<?php echo _REALESTATE_MANAGER_LABEL_ALL;?>'){
          rem_setAllselect_mod('city');
          return;
        }

        for(var c=0;c<regionscitys[id].length;c++){
            rem_createOptionList_mod('city', regionscitys[id][c],regionscitys[id][c]);
        }
      }
      //end city

      function rem_clearSelectList_mod(elementName){
        var objSelect=document.getElementsByName(elementName)[0];
        while(objSelect.options.length > 0){objSelect.remove(0);}
        return objSelect;
      }

      function rem_in_array_select_mod(what, where) {
        for(var i=0; i<where.length; i++){
          if(what == where[i]){
            return i;
          }
        }
        return false;
      }

      function rem_createOptionList_mod(elementName, newValue,newText){
        var objSelect = document.getElementsByName(elementName)[0];
        var objOption = document.createElement("option");
        objOption.text = newText
        objOption.value = newValue
        if(document.all && !window.opera){
          objSelect.add(objOption);
        }else{
          objSelect.add(objOption, null);
        };
      }

      function rem_setAllselect_mod(elementName){
        rem_createOptionList_mod(elementName, '<?php echo _REALESTATE_MANAGER_LABEL_ALL;?>','<?php echo _REALESTATE_MANAGER_LABEL_ALL;?>');
      }
</script>
<?php } ?>
            <?php
            if( ($params->get('label_country') == 0 || $params->get('label_country') == 2  ) && $params->get('label_region') == 0) { ?>
                <div class="col_box_2">
                    <span><?php echo _REALESTATE_MANAGER_LABEL_REGION; ?></span>
                    <?php echo $params->get('region'); ?>
                </div>
            <?php } else   if( ($params->get('label_country') == 0 || $params->get('label_country') == 2  ) && $params->get('label_region') == 2) {
                echo  '<input type="hidden" name="hregion"  value="' ._REALESTATE_MANAGER_LABEL_ALL .'" />';
              } ?>

        <?php  if( ($params->get('label_country') == 0 || $params->get('label_country') == 2 )
                  && ($params->get('label_region') == 0 || $params->get('label_region') == 2 )
                  && $params->get('label_city') == 0) { ?>
          <div  class="col_box_2">
            <span><?php echo _REALESTATE_MANAGER_LABEL_CITY; ?></span>
                    <?php echo $params->get('city'); ?>
          </div>
        <?php } ?>
      <?php } ?>
    <!--*********************************** contry, region, city END ***********************************-->

<!--***********************************add extra fields***********************************-->
<?php
for($i=6;$i<=10;$i++){
    if($params->get('label_show_custom_dropdown_field_'. $i) == 0){ ?>
        <div class="col_box_2">
          <span><?php echo constant('_REALESTATE_MANAGER_ADMIN_CONFIG_EXTRA' .$i . '_SHOW'); ?></span>
          <?php echo $params->get('extrafield'.$i); ?>
        </div><!-- col_box_2 -->
<?php }
}
?>
<!-- *********************************** end add extra fields ****************************** -->
</div>
        <div class="mod_container_checkbox">
            <?php if($label_propertyid==0){?>
                <div class="col_box_3">
                    <span><?php echo _REALESTATE_MANAGER_LABEL_PROPERTYID; ?></span>
                    <input type="checkbox" name="Houseid" id="Houseid" checked = "checked"/>
                </div>
            <?php } elseif($label_propertyid==1){ ?>
                <input type="hidden" name="Houseid" value="on">
            <?php } ?>

            <?php if($label_description==0){?>
                <div class="col_box_3">
                    <span><?php echo _REALESTATE_MANAGER_LABEL_DESCRIPTION; ?></span>
                    <input type="checkbox" name="Description" id="Description" checked = "checked"/>
                </div>
            <?php } elseif($label_description==1){ ?>
                <input type="hidden" name="Description" value="on">
            <?php } ?>

            <?php if($label_title==0){?>
                <div class="col_box_3">
                    <span><?php echo _REALESTATE_MANAGER_LABEL_TITLE; ?></span>
                    <input type="checkbox" name="Title" id="Title" checked = "checked"/>
                </div>
            <?php } elseif($label_title==1){ ?>
                <input type="hidden" name="Title" value="on">
            <?php } ?>

        <?php if($realestatemanager_configuration['show_country_region_city_as_text_field'] == 1) { ?>
            <?php if($label_country==0){?>
                <div class="col_box_3">
                    <span><?php echo _REALESTATE_MANAGER_LABEL_COUNTRY; ?></span>
                    <input type="checkbox" name="Country" id="Country" checked="checked" />
                </div>
            <?php } ?>

            <?php if($label_region==0){?>
                <div class="col_box_3">
                    <span><?php echo _REALESTATE_MANAGER_LABEL_REGION; ?></span>
                    <input type="checkbox" name="Region" id="Region" checked="checked" />
                </div>
            <?php } ?>

            <?php if($label_city==0){?>
                <div class="col_box_3">
                    <span><?php echo _REALESTATE_MANAGER_LABEL_CITY; ?></span>
                    <input type="checkbox" name="City" id="City" checked="checked" />
                </div>
            <?php } ?>
        <?php
        }
        ?>


            <?php if($label_address==0){?>
                <div class="col_box_3">
                    <span><?php echo _REALESTATE_MANAGER_LABEL_ADDRESS; ?></span>
                    <input type="checkbox" name="Address" id="Address" checked = "checked" />
                </div>
            <?php } elseif($label_address==1){ ?>
                <input type="hidden" name="Address" value="on">
            <?php } ?>

            <?php if($label_zipcode==0){?>
                <div class="col_box_3">
                    <span><?php echo _REALESTATE_MANAGER_LABEL_ZIPCODE; ?></span>
                    <input type="checkbox" name="Zipcode" id="Zipcode" checked="checked" />
                </div>
            <?php } elseif($label_zipcode==1){ ?>
                <input type="hidden" name="Zipcode" value="on">
            <?php } ?>

            <?php if($label_owner==0){?>
                <div class="col_box_3">
                    <span><?php echo _REALESTATE_MANAGER_SHOW_SEARCH_OWNER; ?></span>
                    <input type="checkbox" name="ownername" id="ownername" checked="checked" />
                </div>
            <?php } elseif($label_owner==1){ ?>
                <input type="hidden" name="ownername" value="on">
            <?php } ?>

            <!-- <?php if($label_garages==0){?>
                <div class="col_box_3">
                    <span><?php echo _REALESTATE_MANAGER_LABEL_GARAGES; ?></span>
                    <input type="checkbox" name="Garages" id="Garages" checked="checked" />
                </div>
            <?php } elseif($label_garages==1){ ?>
                <input type="hidden" name="Garages" value="on">
            <?php } ?>

            <?php if($label_build_year==0){?>
                <div class="col_box_3">
                    <span><?php echo _REALESTATE_MANAGER_LABEL_BUILD_YEAR; ?></span>
                    <input type="checkbox" name="year" id="year" checked="checked" />
                </div>
            <?php } elseif($label_build_year==1){ ?>
                <input type="hidden" name="year" value="on">
            <?php } ?> -->

            <?php if($label_contacts==0){?>
                <div class="col_box_3">
                    <span><?php echo _REALESTATE_MANAGER_LABEL_CONTACTS; ?></span>
                    <input type="checkbox" name="Contacts" id="Contacts" checked="checked" />
                </div>
            <?php } elseif($label_contacts==1){ ?>
                <input type="hidden" name="Contacts" value="on">
            <?php } ?>

            <?php if($label_agent==0){?>
                <div class="col_box_3">
                    <span><?php echo _REALESTATE_MANAGER_LABEL_AGENT; ?></span>
                    <input type="checkbox" name="Agent" id="Agent" checked="checked" />
                </div>
            <?php } elseif($label_agent==1){ ?>
                <input type="hidden" name="Agent" value="on">
            <?php } ?>

            <?php
            for($i=1;$i<=5;$i++){
                if($params->get('label_show_custom_text_' . $i) == 0){ ?>
                    <div class="col_box_3">
                      <span><?php echo constant('_REALESTATE_MANAGER_ADMIN_CONFIG_EXTRA' .$i . '_SHOW'); ?></span>
                     <input type="checkbox" name="extra<?php echo $i; ?>" id="extra<?php echo $i; ?>" checked="checked" />
                    </div><!-- col_box_2 -->
            <?php } elseif($params->get('label_show_custom_text_' . $i) == 1) { ?>
                    <input type="hidden" name="extra<?php echo $i; ?>" id="extra<?php echo $i; ?>" value="on">
            <?php
                }
            }
            ?>

            <?php if($label_search_exactly==0){?>
                <div class="col_box_3">
                    <span><?php echo _REALESTATE_MANAGER_SHOW_SEARCH_EXACTLY; ?></span>
                    <input type="checkbox" name="exactly" id="exactly"/>
                </div>
            <?php } elseif($label_search_exactly==1){ ?>
                <input type="hidden" name="exactly" value="on">
            <?php } ?>

        </div>
            <div class="search_button">
                <input type="submit" value="<?php echo _REALESTATE_MANAGER_LABEL_SEARCH_BUTTON; ?>" class="button" />
            </div>
            <input type="hidden" name="typeLayout" value="alone_category" />
            <input type="hidden" name="searchLayout" value="<?php echo $searchLayout; ?>" />
            <input type="hidden" name="option" value="com_realestatemanager" />
            <input type="hidden" name="task" value="search" />
            <input type="hidden" name="Itemid" value="<?php echo $ItemId ?>" />
        </form>
    </div>
</div>
