<?php

/**
 * @version		$Id: topofthepage.php 20196 2011-03-04 02:40:25Z mrichey $
 * @package		plg_sys_topofthepage
 * @copyright	Copyright (C) 2005 - 2011 Michael Richey. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die;

jimport('joomla.plugin.plugin');

class plgSystemTopofthepage extends JPlugin {

    var $_app = false;
    var $_doc = false;
    var $_initialized = false;

    public function onBeforeCompileHead() {
	$this->_app = JFactory::getApplication();
	$this->_doc = JFactory::getDocument();
	
	// reasons to exit
	if (
		$this->_initialized ||
		($this->_app->isAdmin() && !$this->params->get('runinadmin', 0)) || // do we run in administrator ?
		$this->_doc->getType() != 'html' || // we don't run in pages that aren't html
		in_array(JRequest::getString('tmpl'), array('component', 'raw')) // we don't run in modal pages or other incomplete pages
	) {
	    return true;
	}
	
	$this->_initialized = true;
	$this->_loadHead();
	return true;
    }

    private function _loadHead() {
	$debug = $this->_app->getCfg('debug', false) ? '' : '.min';
	JHtml::_('jquery.framework', true, true);
	$config = $this->params->jsonSerialize();
	
	$this->_doc->addScript(JURI::root(true) . '/media/plg_system_topofthepage/topofthepage' . $debug . '.js');
	$css = str_replace('#gototop','#plg_system_topofthepage',$config->linkstyle);
	unset($config->usestyle);
	unset($config->linkstyle);
	unset($config->runinadmin);
	JText::script('PLG_SYS_TOPOFTHEPAGE_ARIA_LABEL');
	if (!$this->params->get('omittext', 0))
	{
	    $this->_app->getLanguage()->load('plg_system_topofthepage', JPATH_ADMINISTRATOR);
	    JText::script('PLG_SYS_TOPOFTHEPAGE_GOTOTOP');
	}
	$this->_doc->addScriptDeclaration("\nwindow.plg_system_topofthepage_options = ".json_encode($config)."\n");
	if ($this->params->get('usestyle', 1) == 1) {
	    $this->_doc->addStyleDeclaration("\n".$css."\n");
	}
    }

}
